<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Inside\Settings\Models\Setting;

class DeleteStoneIndexesInDatabase extends Migration
{
    /**
     * @var string[]
     */
    protected array $contentTypes = [
        'stone_footer_menu_links',
        'stone_main_menu_links',
        'stone_dms_link',
        'spaces_pages',
        'spaces_categories_pages',
        'stone_spaces',
        'stone_news',
        'stone_events',
        'stone_tools',
        'stone_documents',
        'stone_folders',
        'stone_news_categories',
        'stone_events_categories',
        'stone_tools_categories',
    ];

    public function up(): void
    {
        $class = collect($this->contentTypes)->map(fn (string $type) => type_to_class($type))->toArray();

        DB::table('inside_search_database_indexes')
            ->whereIn('indexable_type', $class)
            ->delete();

        DB::table('inside_search_database_indexes')
            ->whereIn('langcode', ['en', 'de'])
            ->delete();

        DB::table('inside_models')
            ->whereIn('class', $class)
            ->delete();

        DB::table('inside_statistics')
            ->whereIn('statisticable_type', $class)
            ->delete();

        DB::table('inside_permissions')
            ->whereIn('type', $class)
            ->delete();

        DB::table('inside_permissions_schema')
            ->whereIn('authorizable_type', $class)
            ->delete();

        DB::table('inside_pivots')
            ->whereIn('parent_type', $class)
            ->orWhereIn('related_type', $class)
            ->delete();

        Setting::where('key', 'LIKE', 'stone_%')->delete();
    }
}
