<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;

class DeleteStoneContentTypes extends Migration
{
    /**
     * @var string[]
     */
    protected array $contentTypes = [
        'stone_footer_menu_links',
        'stone_main_menu_links',
        'stone_dms_link',
        'spaces_pages',
        'spaces_categories_pages',
        'stone_spaces',
        'stone_news',
        'stone_events',
        'stone_tools',
        'stone_documents',
        'stone_folders',
        'stone_news_categories',
        'stone_events_categories',
        'stone_tools_categories',
    ];

    public function up(): void
    {
        $bridge = new BridgeContentType();

        foreach ($this->contentTypes as $contentType) {
            if (InsideSchema::hasModel($contentType)) {
                $bridge->contentTypeDelete($contentType);
            }
        }
    }
}
