<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;

class HideLangFields extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        foreach (InsideSchema::getContentTypes() as $contentType) {
            collect([
                'langcode', 'languages'
            ])->each(function ($field) use ($contentType, $bridge) {
                if (InsideSchema::hasField(($contentType), $field)) {
                    $bridge->changeFieldFormOptions($contentType, $field, false, 'group_options');
                }
            });
        }
    }
}
