<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Models\Contents\Tools;

class DeleteJobsRelatedContentTypes extends Migration
{
    public function up(): void
    {
        $types = ['jobs', 'jobs_categories', 'provinces', 'regions', 'contractual_times', 'contract_types'];
        $bridge = new BridgeContentType();

        foreach ($types as $type) {
            $bridge->contentTypeDelete($type);
        }

        $bridgeContent = new BridgeContent();

        $primoJobs = Tools::query()->where('title', 'Primo Job')->get();
        foreach ($primoJobs as $job) {
            $bridgeContent->contentDelete('tools', $job->uuid);
        }
    }
}
