<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class SetJobsFieldsToTranslatable extends Migration
{
    public function up(): void
    {
        $fields = ['job_description', 'profile_description', 'reference_number', 'why_join_us'];
        $bridge = new BridgeContentType();
        foreach ($fields as $field) {
            $bridge->updateFieldOptions('jobs', $field, ['translatable' => true]);
        }
    }

    public function down(): void
    {
    }
}
