<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

class UpdateDefaultUsersTools extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();
        $primoTools = Tools::query()->where('title', 'Primo Job')->get();

        if (empty($primoTools)) {
            throw new Exception('Primo Job tools not found !');
        }

        $users = Users::all();
        foreach ($users as $user) {
            $uuid = null;
            $tools = $user->tools;
            $tools = $tools->pluck('uuid')->toArray();
            $uuid = $primoTools->where('langcode', $user->langcode)->pluck('uuid')->first();

            if (($key = array_search($uuid, $tools)) !== false) {
                unset($tools[$key]);
            }

            array_unshift($tools, $uuid);
            $bridge->contentUpdate('users', [
                'uuid' => $user->uuid,
                'tools' => $tools
            ]);
        }
    }
}
