<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Entities;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Illuminate\Support\Facades\Artisan;

class AddFieldOnEntities extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();

        $bridgeContentType->contentTypeCreateOrUpdateField(
            'entities',
            'stone_entity',
            [
                'name' => 'stone_entity',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'weight' => 6,
                'title' => [
                    'fr' => 'Est-ce une entité stone ?',
                    'en' => 'Is it a stone entity ?',
                    'de' => 'ist es eine stone-Entität?'
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'group' => 'advanced_options',
                    'settings' => [
                        'display_label' => true,
                    ],
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => false,
            ],
            6
        );

        Artisan::call('models:rebuild');
        $entities = Entities::all();
        $bridge = new BridgeContent();
        $allowedEntities = [
            "Primonial REIM Holding",
            "Primonial REIM France",
            "Primonial REIM Germany",
            "Primonial REIM Italy",
            "Primonial REIM Singapore"
        ];

        foreach ($entities as $entity) {
            $bridge->contentUpdate('entities', [
                'uuid' => $entity->uuid,
                'stone_entity' => in_array(trim($entity->title), $allowedEntities)
            ]);
        }
    }

    public function down(): void
    {
    }
}
