<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\ManagerSpacesTools;
use Inside\Content\Models\Contents\StoneTools;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class ReplaceMachineNameLinkInToolsShortcuts extends Migration
{
    public function up(): void
    {
        if (!Schema::hasContentType('manager_spaces_tools')) {
            return;
        }
        $bridgeType = new BridgeContentType();
        $bridge = new BridgeContent();

        $bridgeType->contentTypeCreateOrUpdateField('manager_spaces_tools', 'tools_link', [
            'name' => 'tools_link',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'translatable' => false,
            'editable' => false,
            'search_result_field' => false,
            'required' => true,
            'title' => [
                'fr' => 'Lien',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_LINK_WIDGET,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ]);

        $bridgeType->contentTypeCreateOrUpdateField('stone_tools', 'tools_link', [
            'name' => 'tools_link',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'translatable' => false,
            'editable' => false,
            'search_result_field' => false,
            'required' => true,
            'title' => [
                'fr' => 'Lien',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_LINK_WIDGET,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ]);

        foreach (ManagerSpacesTools::get() as $tool) {
            $bridge->contentUpdate('manager_spaces_tools', [
                'uuid' => $tool->uuid,
                'author' => $tool->author,
                'tools_link' => $tool->link
            ]);
        }
        foreach (StoneTools::get() as $tool) {
            $bridge->contentUpdate('stone_tools', [
                'uuid' => $tool->uuid,
                'author' => $tool->author,
                'tools_link' => $tool->link
            ]);
        }

        $bridgeType->contentTypeDeleteField('node', 'manager_spaces_tools', 'link');
        $bridgeType->contentTypeDeleteField('node', 'stone_tools', 'link');
    }

    public function down(): void
    {
    }
}
