<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddSignUpFieldToEvents extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'events',
            'sign_up',
            [
                'name' => 'sign_up',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'default' => false,
                'weight' => 6,
                'title' => [
                    'fr' => 'Inscription',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => 5,
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
