<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Tools;
use Inside\Database\Migrations\HasConsole;
use Inside\Host\Bridge\BridgeContent;

class FixTools extends Migration
{
    use HasConsole;
    public function up(): void
    {
        $contents = Tools::query()->where('langcode', 'fr')->get();
        $bridge = new BridgeContent();

        $textFields = ['icon', 'image', 'link', 'weight', 'tooltip'];

        foreach ($contents as $content) {
            $needsUpdating = false;
            $translation = $content->getTranslationIfExists('en');

            if (!$translation || $translation->langcode === 'fr') {
                continue;
            }

            $data = [
                'uuid_host' => $content->uuid_host,
                'langcode' => $content->langcode,
            ];

            foreach ($textFields as $textField) {
                if (empty($content->{$textField}) && !empty($translation->{$textField})) {
                    $data[$textField] = $translation->{$textField};
                    $needsUpdating = true;
                }
            }

            if ($content->toolsCategories->count() === 0) {
                $data['tools_categories'] = [];
                foreach ($translation->toolsCategories as $category) {
                    $translationCategory = $category->getTranslationIfExists('fr');

                    if (isset($translationCategory->langcode, $translationCategory->uuid) && $translationCategory->langcode === 'fr') {
                        $data['tools_categories'][] = $translationCategory->uuid;
                        $needsUpdating = true;
                    }
                }
            }

            if ($needsUpdating) {
                $this->writeln('Updating tool ' . $content->title);
                $bridge->contentUpdate('tools', $data);
            }
        }

        Artisan::call('cache:clear');
    }

    public function down(): void
    {
    }
}
