<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\DynamicClass;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AddIsStoneUserField extends Migration
{
    use CreateContentTypes;
    public function up(): void
    {
        DynamicClass::disableRebuildAutoLoad();
        $this->bootUp(__FILE__, 'Add is_stone_user field');

        $this->bridge->contentTypeCreateOrUpdateField('users', 'is_stone_user', [
            'name' => 'is_stone_user',
            'searchable' => true,
            'search_filter' => true,
            'translatable' => false,
            'search_result_field' => true,
            'required' => false,
            'default' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Utilisateur Stone',
                'en' => 'Stone user',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ]);

        $this->finishUp();
        DynamicClass::enableRebuildAutoLoad();
        $this->call('models:rebuild');
    }

    public function down(): void
    {
        $this->bootDown(__FILE__);
        $this->finishDown();
    }
}
