<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\DynamicClass;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AddStoneFields extends Migration
{
    use CreateContentTypes;
    public function up(): void
    {
        DynamicClass::disableRebuildAutoLoad();
        $this->bootUp(__FILE__, 'Add new stone fields');
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'custom', 'image');

        $imageOptions = \Inside\Content\Facades\Schema::getFieldOptions('stone_main_menu_links', 'image');
        $linkOptions = \Inside\Content\Facades\Schema::getFieldOptions('stone_main_menu_links', 'link');

        $fields = [
            [
                'name' => 'banner',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'required' => false,
                'weight' => $linkOptions['weight'],
                'title' => [
                    'fr' => 'Bannière',
                    'en' => 'Banner',
                ],
                'widget' => [
                    'type' => BridgeContentType::IMAGE_WIDGET,
                    'settings' => [
                        'progress_indicator' => 'throbber',
                        'preview_image_style' => 'thumbnail',
                    ],
                    'weight' => $linkOptions['weight'],
                ],
                'type' => BridgeContentType::IMAGE_FIELD,
                'settings' => [
                    'uri_scheme' => 'public',
                    'default_image' => [
                        'uuid' => '',
                        'alt' => '',
                        'title' => '',
                        'width' => null,
                        'height' => null,
                    ],
                    'target_type' => 'file',
                    'display_field' => false,
                    'display_default' => false,
                    'cardinality' => 1,
                ],
            ],
            [
                'name' => 'introduction',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'required' => false,
                'weight' => $imageOptions['weight'],
                'title' => [
                    'fr' => 'Introduction',
                    'en' => 'Introduction',
                ],
                'description' => [],
                'widget' => [
                    'type' => BridgeContentType::LONGTEXT_WIDGET,
                    'settings' => [
                        'rows' => 5,
                        'placeholder' => '',
                    ],
                    'weight' => $imageOptions['weight'],
                ],
                'type' => BridgeContentType::TEXTAREA_FIELD,
                'settings' => [
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        ];

        foreach ($fields as $field) {
            $bridge->contentTypeCreateOrUpdateField('stone_main_menu_links', $field['name'], $field, $field['weight']);
        }

        $this->finishUp();
        DynamicClass::enableRebuildAutoLoad();
        $this->call('models:rebuild');
    }

    public function down(): void
    {
        $this->bootDown(__FILE__);
        $this->finishDown();
    }
}
