<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class ChangeStoneListingTypes extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $types = [
            'taxo' => ['stone_events_categories', 'stone_folders', 'stone_news_categories', 'stone_tools_categories'],
            'content' => ['stone_documents', 'stone_events', 'stone_footer_menu_links', 'stone_main_menu_links', 'stone_news', 'stone_tools'],
        ];

        foreach ($types as $type => $contentTypes) {
            foreach ($contentTypes as $contentType) {
                $bridge->updateContentTypeOptions($contentType, ['listing_type' => $type]);
            }
        }
    }

    public function down(): void
    {
    }
}
