<?php

use Inside\Database\Migrations\HasConsole;
use Inside\Host\Bridge\BridgeContentType;
use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class AddCommentsOnStoneContentTypes extends Migration
{
    use HasConsole;

    public function up(): void
    {
        $contentTypes = ['stone_news', 'stone_events'];
        $bridge = new BridgeContentType();

        foreach ($contentTypes as $contentType) {
            $bridge->contentTypeCreateOrUpdateField($contentType, 'comments', [
                'name' => 'comments',
                'searchable' => false,
                'translatable' => false,
                'default' => [],
                'search_result_field' => false,
                'required' => false,
                'weight' => 20,
                'title' => [
                    'fr' => 'Commentaires'
                ],
                'description' => [
                    'fr' => ''
                ],
                'widget' => [
                    'hidden' => true,
                ],
                'type' => BridgeContentType::COMMENT_FIELD,
                'settings' => [
                    'comment_type' => 'comments',
                    'cardinality' => 1,
                ],
            ]);
        }

        $this->write(
            'Recherche de la notification de <fg=magenta>Commentaires</fg=magenta>'
        );

        /**
         * @var ?NotificationType $notificationType
         */
        $notificationType = NotificationType::where(
            [
                'via'    => 'web',
                'event'  => \Inside\Content\Events\CommentCreatedEvent::class,
                'model'  => \Inside\Content\Models\Contents\Comments::class,
                'action' => 'contentCommented',
            ]
        )->first();
        if ($notificationType === null) {
            $this->writeResult(false);

            return;
        }
        $this->write(' (<fg=cyan>' . $notificationType->id . '</fg=cyan>)');
        $this->writeResult(true);
        // Notification de report
        $this->write(
            'Modification notification de <fg=magenta>Commentaires</fg=magenta>'
        );
        $this->writeResult(
            $notificationType->update(
                [
                    'condition' => 'parent_type:news,events,manager_spaces_events,movements,stone_news,stone_events',
                ]
            )
        );
    }
}
