<?php


use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;

class AddStoneContentTypes extends Migration
{
    use CreateContentTypes;

    /**
     * @var string[]
     */
    protected $contentTypes = [
        'stone_news_categories',
        'stone_events_categories',
        'stone_tools_categories',
        'stone_folders',
        'stone_news',
        'stone_events',
        'stone_tools',
        'stone_documents',
        'stone_main_menu_links',
        'stone_footer_menu_links',
    ];

    public function up(): void
    {
        $this->bootUp(__FILE__);

        foreach ($this->contentTypes as $contentType) {
            $this->migrateContent($contentType);
        }

        $this->finishUp();
    }

    public function down(): void
    {
        foreach ($this->contentTypes as $contentType) {
            $this->bridge->contentTypeDelete($contentType);
        }
    }
}
