<?php

use Inside\Content\Facades\DynamicClass;
use Inside\Database\Migrations\HasConsole;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Notify\Migrations\ReportMigration;
use Inside\Notify\Models\NotificationType;

class addCommentsOnMovements extends ReportMigration
{
    use HasConsole;

    public function up(): void
    {
        DynamicClass::withoutRebuildAutoLoad(
            function () {
                $typeBridge = new BridgeContentType();
                $this->write(
                    'Ajout du champ <fg=cyan>Commentaires</fg=cyan> au contenu <fg=magenta>Mouvements</fg=magenta>'
                );
                $this->writeResult(
                    $typeBridge->contentTypeCreateOrUpdateField(
                        'movements',
                        'comments',
                        [
                            'name'         => 'comments',
                            'searchable'   => false,
                            'required'     => false,
                            'translatable' => true,
                            'type'         => BridgeContentType::COMMENT_FIELD,
                            'title'        => [
                                'fr' => 'Commentaires',
                            ],
                            'settings'     => [
                                'comment_type' => 'comments',
                            ],
                        ]
                    )
                );

                // Notification de report
                $this->write(
                    'Création du type de notification de <fg=cyan>report</fg=cyan> de <fg=magenta>Commentaires</fg=magenta>'
                );
                $this->writeResult(NotificationType::firstOrCreate(
                    $this->getNotificationData('comments', 'web', 'ROOT_RELATION:news,events,manager_spaces_events,movements')
                ) !== null);
                $this->write(
                    'Enregistrement <fg=cyan>report</fg=cyan> de <fg=magenta>Commentaires</fg=magenta>'
                );
                $this->registerReport(['super_administrator'], 'comments', true, false, 'ROOT_RELATION:news,events,manager_spaces_events,movements');
                $this->writeResult(true);
            }
        );
    }
}
