<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddNewsFieldToCorporate extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'corporates',
            'news',
            [
                'name'                => 'news',
                'searchable'          => false,
                'translatable'        => false,
                'default'             => [],
                'search_result_field' => true,
                'required'            => false,
                'weight'              => -4,
                'title'               => [
                    'fr' => 'Actualités',
                ],
                'description'         => [
                    'fr' => '',
                ],
                'widget'              => [
                    'type'     => BridgeContentType::AUTOCOMPLETE_WIDGET,
                    'settings' => [
                        'match_operator' => 'CONTAINS',
                        'size'           => 60,
                        'placeholder'    => '',
                    ],
                    'weight'   => -2,
                ],
                'type'                => BridgeContentType::REFERENCE_FIELD,
                'settings'            => [
                    'target_type' => 'news',
                    'cardinality' => -1,
                ],
            ]
        );
    }
}
