<?php


use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class EditFoldersSubtitles extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new \Inside\Host\Bridge\BridgeContentType();

        $bridgeContentType->contentTypeDeleteField('node', 'folders', 'media_folder_intro');

        $bridgeContentType->contentTypeCreateOrUpdateField('folders', 'media_folder_intro', [
            'name' => 'media_folder_intro',
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'title' => [
                'fr' => 'Sous titre du dossier',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
            ],
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
