<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateEntitiesFields extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new \Inside\Host\Bridge\BridgeContentType();

        $bridgeContentType->contentTypeDeleteField('node', 'entities', 'introduction');

        $bridgeContentType->contentTypeCreateOrUpdateField(
            'entities',
            'entities_listing',
            [
                'name' => 'entities_listing',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'default' => true,
                'weight' => 0,
                'title' => [
                    'fr' => 'Afficher sur la page d\'entité ?',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => 0,
                    'group' => 'group_advanced_options',
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ]
        );

        $bridgeContentType->contentTypeCreateOrUpdateField(
            'entities',
            'website',
            [
                'name' => 'website',
                'searchable' => true,
                'translatable' => false,
                'default' => null,
                'search_result_field' => false,
                'required' => false,
                'weight' => 1,
                'title' => [
                    'fr' => 'Site web'
                ],
                'description' => [],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 1,
                    'group' => 'group_advanced_options',
                ],
                'type' => BridgeContentType::TEXT_FIELD
            ]
        );

        $bridgeContentType->contentTypeCreateOrUpdateField(
            'entities',
            'instagram',
            [
                'name' => 'instagram',
                'searchable' => false,
                'translatable' => false,
                'default' => null,
                'search_result_field' => false,
                'required' => false,
                'weight' => 4,
                'title' => [
                    'fr' => 'Instagram'
                ],
                'description' => [],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 4,
                    'group' => 'group_advanced_options',
                ],
                'type' => BridgeContentType::TEXT_FIELD
            ]
        );

        $bridgeContentType->contentTypeCreateOrUpdateField(
            'entities',
            'facebook',
            [
                'name' => 'facebook',
                'searchable' => false,
                'translatable' => false,
                'default' => null,
                'search_result_field' => false,
                'required' => false,
                'weight' => 5,
                'title' => [
                    'fr' => 'Facebook'
                ],
                'description' => [],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 5,
                    'group' => 'group_advanced_options',
                ],
                'type' => BridgeContentType::TEXT_FIELD
            ]
        );
    }

    public function down(): void
    {
    }
}
