<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddChapoToArticleBlog extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->bridge->contentTypeCreateOrUpdateField(
            'article_blog',
            'chapo',
            [
                'name' => 'chapo',
                'type' => BridgeContentType::TEXTAREA_FIELD,
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Chapô',
                ],
                'widget' => [
                    'type' => BridgeContentType::LONGTEXT_WIDGET,
                    'settings' => [
                        'rows' => 5,
                        'placeholder' => '',
                    ],
                ],
                'settings' => [
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        );
        $this->finishUp();
    }

    public function down(): void
    {
    }
}
