<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\News;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class AddNewsListingField extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new \Inside\Host\Bridge\BridgeContentType();

        $bridgeContentType->contentTypeCreateOrUpdateField('news', 'news_listing', [
            'name' => 'news_listing',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'default' => true,
            'weight' => 8,
            'title' => [
                'fr' => 'Afficher sur la page d\'actualité ?',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 8,
                'group' => 'group_advanced_options',
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ]);

        $bridge = new BridgeContent();
        $news = News::query()->get();

        foreach ($news as $item) {
            $bridge->contentUpdate('news', [
                'type' => 'node',
                'bundle' => 'news',
                'news_listing' => 1,
                'uuid' => $item->uuid,
            ]);
        }
    }

    public function down(): void
    {
    }
}
