<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'news',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Actualités',
            'en' => 'News',
            'de' => 'Nachrichten',
        ],
    ],
    'fields' => [
        [
            'name' => 'languages',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 10,
            'title' => [
                'fr' => 'Langues dans lesquelles vous souhaitez traduire le contenu',
                'en' => 'Languages into which you wish to translate the content',
                'de' => 'Sprachen, in die Sie den Inhalt übersetzen möchten'
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 10,
            ],
            'settings' => [
                'target_type' => ['languages'],
                'cardinality' => -1,
            ],
        ],
    ],
];
