<?php

return [
    'manual_notifications' => [
        'enabled' => true,
        'enabled_types' => [
            'folders',
            'events',
            'documents',
            'news',
            'pages',
            'movements',
        ],
        'custom_url' => function (string $channel, string $type, string $id): ?string {
            switch ($type) {
                case 'folders':
                case 'documents':
                    return 'CUSTOM:roles_notifications';
            }
            return null;
        },
        'enhanced_notifications' => true,
        'enhanced_notifications_types_and_fields' => [
            'news' => [
                'fields' => [
                    'image',
                    'chapo'
                ],
                'options' => [
                    'default_category_color' => '#00bcb4'
                ],
            ],
            'events' => [
                'fields' => [
                    'image',
                    'chapo'
                ],
                'options' => [
                    'default_category_color' => '#00bcb4'
                ],
            ],
        ]
    ],
    'build_url_callbacks' => [
        'roles_notifications' => function ($model) {
            switch ($model->langcode) {
                case 'en':
                    $baseGED = 'library?folder=';
                    break;
                case 'de':
                    $baseGED = 'bibliothek?folder=';
                    break;
                case 'fr':
                default:
                    $baseGED = 'bibliotheque?folder=';
                    break;
            }
            switch ($model->content_type) {
                case 'folders':
                    return $baseGED.$model->uuid;
                case 'documents':
                    return $baseGED.$model->folders->first()->uuid.'#&modal/documents/'.$model->uuid;
                default:
                    return $model->slug[0] ?? null;
            }
        },
    ],
];
