<?php

use Illuminate\Support\Facades\Route;

Route::group(
    [
        'namespace'  => 'Inside\User\Http\Controllers',
        'prefix'     => 'api/v1',
        'middleware' => 'auth.api',
    ],
    function ($router) {
        $router->get('users/options', ['uses' => 'UserController@options']);

        $router->get('users/find/{attribute}/{value}', ['uses' => 'UserController@find']);

        $router->get('users', ['uses' => 'UserController@all']);

        $router->get('users/{id}', ['uses' => 'UserController@get']);

        $router->post('users/register', ['uses' => 'UserController@register']);

        $router->delete('users/{id}', ['uses' => 'UserController@delete']);

        $router->put('users/{id}', ['uses' => 'UserController@update']);

        // Password reset
        $router->put('password/reset', ['uses' => 'UserController@reset', 'as' => 'password.reset']);
        $router->post('password/email', ['uses' => 'UserController@sendResetLinkEmail']);
        $router->post('password/create/email', ['uses' => 'UserController@sendCreateLinkEmail']);
        $router->post('token/validate', ['uses' => 'UserController@validateToken']);
    }
);

Route::group(
    [
        'namespace'  => 'Inside\User\Http\Controllers',
        'middleware' => 'auth',
    ],
    function ($router) {
        $router->get('avatar/users/{id}', ['uses' => 'UserController@avatar']);
    }
);
