<?php

namespace Inside\User\Transformers;

use Inside\User\Models\User;
use League\Fractal\TransformerAbstract;

class UserTransformer extends TransformerAbstract
{
    /**
     * @param User $user
     * @return array
     */
    public function transform(User $user): array
    {
        $fillable = array_diff($user->getFillable(), ['password']);
        $transformed = ['uuid' => (string) $user->uuid];
        foreach ($fillable as $field) {
            $transformed[$field] = (string) $user->{$field};
        }

        return $transformed;
    }
}
