<?php

namespace Inside\User\Notifications;

use Illuminate\Auth\Notifications\ResetPassword;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Support\Facades\Lang;

class ResetPasswordNotification extends ResetPassword
{
    /**
     * @var string
     */
    public $email;

    public function __construct(string $token, string $email)
    {
        parent::__construct($token);

        $this->email = $email;
    }

    /**
     * @param mixed $notifiable
     * @return MailMessage
     */
    public function toMail($notifiable)
    {
        Lang::setLocale($notifiable->langcode);
        $data = [
            'expire' => config('auth.passwords.users.expire'),
            'url' => config('app.url'),
        ];

        return (new MailMessage())->subject(Lang::get('mail.password_reset.subject', $data))->line(
            nl2br(Lang::get('mail.password_reset.main_text', $data))
        )->action(
            Lang::get('mail.password_reset.button_text', $data),
            url(config('app.url').'/password/reset?token='.$this->token.'&email='.$this->email)
        )->salutation(Lang::get('mail.password_reset.salutation', $data))->greeting(
            Lang::get('mail.password_reset.greeting', $data)
        )->markdown('emails.notification');
    }
}
