<?php

namespace Inside\User\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Collection;
use Inside\Authentication\Models\User as AuthenticationUser;

/**
 * @method static User|null find(string $uuid, array $columns = ['*'])
 * @method static User create(array $attributes = [])
 * @method static Collection<User>|User[] get(array $columns = ['*'])
 * @method static LengthAwarePaginator paginate(int $perPage = null, array $columns = ['*'], string $pageName = 'page', int|null $page = null)
 * @method static Builder where($column, $operator = null, $value = null, $boolean = 'and')
 *
 * @property string $api_token
 */
class User extends AuthenticationUser
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'uuid',
        'uuid_host',
        'api_token',
        'status',
        'remember_token',
        'langcode',
        'created_at',
        'updated_at',
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'api_token',
        'remember_token',
    ];
}
