<?php

namespace Inside\User\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Authentication\Events\UserDecisionized;
use Inside\User\Jobs\DisableUserJob;

class DecisionizeUser implements ShouldQueue
{
    /**
     * @param UserDecisionized $event
     * @return void
     */
    public function handle(UserDecisionized $event)
    {
        DisableUserJob::dispatch($event->getUserUuid());
    }
}
