<?php

namespace Inside\User\Console;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Inside\Console\Command;
use Inside\User\Jobs\SendCreatePasswordMail;

class SendPasswordCreateMails extends Command
{
    /**
     * @var string
     */
    protected $name = 'inside:user:send-password-create-mails';

    /**
     * @var string
     */
    protected $signature = 'inside:user:send-password-create-mails {--limit=} {--status} {--reset} {--p|provider=}';

    /**
     * @var string
     */
    protected $description = 'Renvoi des mails de création de mot de passe';

    /**
     * @var string
     */
    protected $tableName = 'inside_temp_password_mails_sent';

    /**
     * @return void
     */
    public function handle()
    {
        if ($this->option('reset')) {
            if (Schema::hasTable($this->tableName)) {
                $this->info('Deleting temp table');
                Schema::drop($this->tableName);
                $this->info('Temp table successfully deleted');
            } else {
                $this->info('Temp table does not exist, nothing to do');
            }

            return;
        }
        if ($this->option('status') && ! Schema::hasTable($this->tableName)) {
            $this->info('Temp table does not exist');

            return;
        }

        if (! Schema::hasTable($this->tableName)) {
            $this->info('Temp table does not exist, creating');
            Schema::create($this->tableName, function (Blueprint $table) {
                $table->dateTime('date_sent')->nullable();
                $table->uuid('user_uuid');
                $table->foreign('user_uuid')->references('uuid')->on('inside_users')->onDelete('cascade');
            });
            Schema::table($this->tableName, function (Blueprint $table) {
                $table->index(['user_uuid', 'date_sent']);
            });
            $this->info('Temp table created');
        }
        $query = DB::table('inside_content_users')
            ->join('inside_users', 'inside_content_users.uuid', '=', 'inside_users.uuid')
            ->select('inside_content_users.uuid', 'inside_content_users.email', 'inside_users.provider_type')
            ->where('send_mail', true)
            ->where('provider_type', $this->option('provider'))
            ->whereNotExists(function ($subQuery) {
                $subQuery->select(DB::raw(1))
                    ->from($this->tableName)
                    ->whereRaw(sprintf('inside_content_users.uuid = %s.user_uuid', $this->tableName));
            })
            ->whereNotExists(function ($subQuery) {
                $subQuery->select(DB::raw(1))
                    ->from('inside_authentication_tokens')
                    ->whereRaw('inside_content_users.uuid = inside_authentication_tokens.user_uuid');
            });

        if ($query->count() === 0 || $this->option('status')) {
            if ($query->count() === 0) {
                $this->info(sprintf('%d mails have been sent, and there are no mails left to send', DB::table($this->tableName)->count()));
            } else {
                $this->info(sprintf('%d mails have been sent, and there are still %d mails to send', DB::table($this->tableName)->count(), $query->count()));
            }

            return;
        }

        if (! $this->option('limit') && ! $this->confirm(sprintf('You have not set a limit, are you sure you want to continue? That would send mails to %d users', $query->count()))) {
            $this->info('No mails were sent');

            return;
        }

        if ($this->option('limit')) {
            if (! is_numeric($this->option('limit'))) {
                $this->error('Limit has to be a number');

                return;
            }
            $query = $query->limit((int) $this->option('limit'));
        }
        $users = $query->get();

        foreach ($users as $user) {
            DB::table('inside_password_resets')->where('email', $user->email)->delete();
            SendCreatePasswordMail::dispatch($user->uuid);
        }
    }
}
