<?php

namespace Inside\User\Console;

use Inside\Console\Command;
use Inside\User\Jobs\DisableExpiredUsersJob;

class DisableExpiredUsersCommand extends Command
{
    /**
     * @var string
     */
    protected $signature = 'inside:user:disable-expired {--S|silent} {--d|dry-run}';

    /**
     * @var string
     */
    protected $description = 'Décommissionnement des utilisateurs expirés';

    /**
     * @return void
     */
    public function handle()
    {
        if (config('users.decommissioning', false) !== true) {
            $confirm = $this->confirm('Decommissioning is not enable (USERS_DECOMMISSIONING=false), users found will just be blocked, not decommissioned. Do you want to continue ?');
            if (! $confirm) {
                return;
            }
        }
        DisableExpiredUsersJob::dispatchNow($this->option('silent') ? null : $this, $this->option('dry-run')); // we give command to the job in order to display info in console.
    }
}
