<?php

use Inside\Import\Facades\UserImport;
use Inside\Import\Services\ConvertDateService;
use Inside\Import\Services\CreateRelationService;
use Inside\Import\Services\FindManagerService;
use Inside\User\Models\User;

if (! function_exists('reference')) {
    function reference(string $contentType): CreateRelationService
    {
        return CreateRelationService::of($contentType);
    }
}

if (! function_exists('carbonize')) {
    function carbonize(string $format): ConvertDateService
    {
        return ConvertDateService::format($format);
    }
}

if (! function_exists('avatar')) {
    function avatar(?string $url, ?User $user): ?string
    {
        return UserImport::setUserAvatar($url, $user);
    }
}
