<?php

namespace Inside\Import\Exceptions;

use Exception;

/**
 * Class InvalidReferenceException
 */
class InvalidReferenceException extends Exception
{
    /**
     * @param array  $data
     * @param string|null $reference
     * @return static
     */
    public static function withData(array $data, ?string $reference): self
    {
        $referenceString = $reference ?? 'null';

        return new static("Reference `$referenceString` could not be found in data => ".json_encode($data));
    }
}
