<?php

namespace Inside\Import\Events;

use Illuminate\Bus\Queueable;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class RunUserImportCommand implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected string $command;

    public function __construct(string $command)
    {
        $this->command = $command;
    }

    public function handle(): void
    {
        Artisan::call($this->command);
    }
}
