<?php

namespace Inside\Statistics\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Users;
use Inside\Database\Eloquent\WithEnhancedBuilder;
use Inside\Statistics\Events\StatisticSubscribedEvent;

/**
 * @property int $id
 * @property string|null $type
 * @property string $user_uuid
 * @property string $statisticable_uuid
 * @property string $statisticable_type
 * @property string|null $langcode
 * @property int|null $created_at
 * @property int|null $updated_at
 * @property-read Model|Collection $statisticable
 * @property-read User $user
 * @method static \Inside\Database\Eloquent\Builder|Statistic newModelQuery()
 * @method static \Inside\Database\Eloquent\Builder|Statistic newQuery()
 * @method static \Inside\Database\Eloquent\Builder|Statistic query()
 * @method static Builder|Statistic where($column, $operator = null, $value = null, $boolean = 'and')
 * @method static Builder|Statistic whereCreatedAt($value)
 * @method static Builder|Statistic whereId($value)
 * @method static Builder|Statistic whereLangcode($value)
 * @method static Builder|Statistic whereStatisticableType($value)
 * @method static Builder|Statistic whereStatisticableUuid($value)
 * @method static Builder|Statistic whereType($value)
 * @method static Builder|Statistic whereUpdatedAt($value)
 * @method static Builder|Statistic whereUserUuid($value)
 * @method static Builder|Statistic select(array|mixed $columns)
 * @method static Builder|Statistic selectRaw(string $expression, array $bindings = [])
 * @method static static create($data)
 * @mixin Collection
 */
class Statistic extends Model
{
    use WithEnhancedBuilder;

    /**
     * @var string
     */
    protected $table = 'inside_statistics';

    /**
     * @var array
     */
    protected $fillable = [
        'user_uuid',
        'type',
        'langcode',
        'statisticable_uuid',
        'statisticable_type',
        'created_at',
        'updated_at',
    ];

    /**
     * @var array
     */
    protected $hidden = [
        'id',
        'updated_at',
    ];

    /**
     * @var array
     */
    protected $guarded = [
        'id',
    ];

    /**
     * @var array
     */
    protected $dates = [
        'created_at',
        'updated_at',
    ];

    /**
     * @var array
     */
    protected $casts = [
        'created_at' => 'timestamp',
        'updated_at' => 'timestamp',
    ];

    /**
     * @return BelongsTo
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_uuid', 'uuid');
    }

    /**
     * @return MorphTo
     */
    public function statisticable(): MorphTo
    {
        return $this->morphTo('statisticable', 'statisticable_type', 'statisticable_uuid');
    }
}
