<?php

namespace Inside\Statistics\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Carbon;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Field;
use Inside\Content\Models\Model;
use Inside\Database\Eloquent\WithEnhancedBuilder;

/**
 * @property int $id
 * @property string $user_uuid
 * @property string $type
 * @property string $uuid
 * @property-read Collection|Field[] $fields
 * @property-read int|null $fields_count
 * @property-read mixed $model
 * @method static \Inside\Database\Eloquent\Builder|ContentVisit newModelQuery()
 * @method static \Inside\Database\Eloquent\Builder|ContentVisit newQuery()
 * @method static \Inside\Database\Eloquent\Builder|ContentVisit query()
 * @method static Builder|ContentVisit whereId($value)
 * @method static Builder|ContentVisit whereType($value)
 * @method static Builder|ContentVisit whereUserUuid($value)
 * @method static Builder|ContentVisit whereUuid($value)
 * @mixin Collection
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @method static Builder|ContentVisit whereCreatedAt($value)
 * @method static Builder|ContentVisit whereUpdatedAt($value)
 * @method static ContentVisit create(array $attributes = [])
 * @method static void truncate()
 */
class ContentVisit extends Model
{
    use WithEnhancedBuilder;

    /**
     * @var string
     */
    protected $table = 'content_visits';

    /**
     * @var array
     */
    protected $fillable = [
        'user_uuid',
        'uuid',
        'type',
    ];

    /**
     * @var bool
     */
    public $timestamps = true;

    /**
     * @return BelongsTo
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_uuid');
    }
}
