<?php

namespace Inside\Statistics\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Inside\Authentication\Models\User;
use Inside\Database\Eloquent\WithEnhancedBuilder;

/**
 * @property int $id
 * @property string $uuid
 * @property string $full_name
 * @property bool $email
 * @property int $enabled
 * @property array $roles
 * @property int $connection_count
 * @property int|null $last_login_at_timestamp
 * @property int $date
 * @method static \Inside\Database\Eloquent\Builder|AuthenticationStatistic newModelQuery()
 * @method static \Inside\Database\Eloquent\Builder|AuthenticationStatistic newQuery()
 * @method static \Inside\Database\Eloquent\Builder|AuthenticationStatistic query()
 * @method static \Inside\Database\Eloquent\Builder select($columns = ['*'])
 * @method static Builder|AuthenticationStatistic whereConnectionCount($value)
 * @method static Builder|AuthenticationStatistic whereEmail($value)
 * @method static Builder|AuthenticationStatistic whereEnabled($value)
 * @method static Builder|AuthenticationStatistic whereFullName($value)
 * @method static Builder|AuthenticationStatistic whereId($value)
 * @method static Builder|AuthenticationStatistic whereLastLoginAtTimestamp($value)
 * @method static Builder|AuthenticationStatistic whereRoles($value)
 * @method static Builder|AuthenticationStatistic whereUuid($value)
 * @method static AuthenticationStatistic orderBy($column, $direction = 'asc')
 * @method static Builder distinct($value = null)
 * @method static void truncate()
 *
 * @mixin Collection
 */
class AuthenticationStatistic extends Model
{
    use WithEnhancedBuilder;

    /**
     * @var bool
     */
    public $timestamps = false;

    /**
     * @var string
     */
    protected $table = 'authentication_statistics';

    /**
     * @var array
     */
    protected $casts = [
        'last_login_at_timestamp' => 'timestamp',
        'email' => 'boolean',
        'date' => 'timestamp',
        'roles' => 'json',
    ];

    protected $with = [
        'user',
    ];

    /**
     * @return BelongsTo
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uuid');
    }
}
