<?php

namespace Inside\Statistics\Listeners;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Storage;
use Inside\Authentication\Models\User;
use Inside\Content\Events\ExportCompletedEvent;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;

class NotifyUserOfCompletedStatisticExport extends BaseNotificationListener implements ShouldQueue
{
    use Queueable;
    use SerializesModels;

    /**
     * @var User
     */
    public $user;

    /**
     * @var string
     */
    public $path;

    /**
     * @var string
     */
    public $disk;

    /**
     * @param User $user
     * @param string $path
     * @param string $disk
     */
    public function __construct(User $user, string $path, string $disk)
    {
        $this->user = $user;
        $this->path = $path;
        $this->disk = $disk;
    }

    /**
     * @return void
     */
    public function handle(): void
    {
        if (! $this->user) {
            return;
        }
        event(new ExportCompletedEvent($this->disk, $this->path, $this->user));
        $types = NotificationType::where('action', 'export')->get();
        foreach ($types as $type) {
            $this->route = $this->user;
            $link = Storage::disk($this->disk)->url($this->path);
            if (config('app.disable_protected_files', false) === true) {
                $link = config('app.url').'/'.config('app.app_storage_path').'/protected/'.$this->path;
            }
            $this->notify($type, $this->user, null, ['extra' => ['link' => $link]]);
        }
    }
}
