<?php

namespace Inside\Statistics\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Authentication\Models\User;
use Inside\Content\Events\CommentCreatedEvent;
use Inside\Statistics\Events\AnalyticLogEvent;

class CommentLogAnalytic implements ShouldQueue
{
    /**
     * @param CommentCreatedEvent $event
     * @return void
     */
    public function handle(CommentCreatedEvent $event): void
    {
        $user = User::find($event->comment->author);
        event(new AnalyticLogEvent('comment', $event->comment, $user, $event->comment->created_at));
    }

    /**
     * @return string|null
     */
    public function viaQueue(): ?string
    {
        return get_low_priority_queue_name();
    }
}
