<?php

namespace Inside\Statistics\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Authentication\Models\User;
use Inside\Reaction\Events\ReactionUnsubscribedEvent;
use Inside\Statistics\Events\AnalyticCancelLogEvent;

class CancelReactionLogAnalytic implements ShouldQueue
{
    /**
     * @param ReactionUnsubscribedEvent $event
     * @return void
     */
    public function handle(ReactionUnsubscribedEvent $event): void
    {
        event(
            new AnalyticCancelLogEvent(
                'reaction.'.$event->reaction->type,
                $event->reaction,
                User::query()->find($event->reaction->user->uuid),
                $event->reaction->created_at
            )
        );
    }

    /**
     * @return string|null
     */
    public function viaQueue(): ?string
    {
        return get_low_priority_queue_name();
    }
}
