<?php

namespace Inside\Statistics\Http\Controllers\Statistics;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Content\Facades\ContentHelper;
use Inside\Content\Models\Contents\Users;
use Inside\Statistics\Repositories\StatisticsBetaRepository;
use InvalidArgumentException;

class UserViewedStatsBeta
{
    public function __invoke(string $uuid, string $type, Request $request, StatisticsBetaRepository $statisticsRepository): JsonResponse
    {
        $statisticsConfig = config('statistics.types', []);
        if (! array_key_exists($type, $statisticsConfig)) {
            throw new InvalidArgumentException('Content type is not defined in the config.');
        }

        $user = Users::findOrFail($uuid);
        $filters = ContentHelper::extractFiltersInputFromRequest($request);
        $query = $statisticsRepository->getUserViewedContentList(
            $user,
            $type,
            $filters,
            $request->get('query')
        );
        $result = ContentHelper::getResultFromQuery($query, $filters, true);

        $result->transform(function ($item) {
            return $item->content;
        });

        return response()->json(
            $result
        );
    }
}
