<?php

namespace Inside\Statistics\Http\Controllers\Statistics;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Authentication\Models\User;
use Inside\Content\Facades\ContentHelper;
use Inside\Statistics\Contracts\Statistic;

class UserViewedStats
{
    public function __invoke(string $type, string $uuid, Request $request, Statistic $statistic): JsonResponse
    {
        /** @var User $user */
        $user = User::findOrFail($uuid);
        $query = $request->get('query');

        return response()->json(
            $statistic->getUserViewedContentList(
                $user,
                explode(',', $type),
                ContentHelper::extractFiltersInputFromRequest($request),
                $query
            )
        );
    }
}
