<?php

namespace Inside\Statistics\Http\Controllers\Statistics;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Content\Facades\ContentHelper;
use Inside\Statistics\Repositories\StatisticsBetaRepository;

class CountSocialBeta
{
    public function __invoke(Request $request, StatisticsBetaRepository $statisticsBetaRepository): JsonResponse
    {
        return response()->json(
            $statisticsBetaRepository->getSocialStats(ContentHelper::extractFiltersInputFromRequest($request))
        );
    }
}
