<?php

namespace Inside\Statistics\Http\Controllers\Statistics;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Content\Facades\ContentHelper;
use Inside\Statistics\Repositories\StatisticsBetaRepository;

class CountContentBeta
{
    public function __invoke(string $type, Request $request, StatisticsBetaRepository $statisticsBetaRepository): JsonResponse
    {
        return response()->json(
            $statisticsBetaRepository->countContent(explode(',', $type), ContentHelper::extractFiltersInputFromRequest($request))
        );
    }
}
