<?php

namespace Inside\Statistics\Http\Controllers\Statistics;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Inside\Content\Facades\ContentHelper;
use Inside\Content\Transformers\ContentTransformer;
use Inside\Statistics\Repositories\StatisticsBetaRepository;
use Inside\Support\Str;
use InvalidArgumentException;

class ContentStatsBeta
{
    public function __invoke(string $type, Request $request, ContentTransformer $contentTransformer, StatisticsBetaRepository $statisticsRepository): JsonResponse
    {
        $statisticsConfig = config('statistics.types', []);
        if (! array_key_exists($type, $statisticsConfig)) {
            throw new InvalidArgumentException('Content type is not defined in the config.');
        }
        $filters = ContentHelper::extractFiltersInputFromRequest($request);
        $query = $statisticsRepository->getContentStatsQuery($type, $filters);
        $result = ContentHelper::getResultFromQuery($query, $filters, true);

        $result->transform(function ($item) use ($type, $statisticsConfig) {
            $attributes = collect($item->getAttributes())->except(['content_uuid']);
            $mergedAttributes = collect($item->content->getAttributes())
                ->merge($attributes)
                ->toArray();
            $mergedAttributes['has_statistics'] = true;
            $mergedAttributes['slug'] = $item->content->getSlugAttribute();
            $categoryFieldName = $statisticsConfig[$type]['category'];
            if ($categoryFieldName) {
                $mergedAttributes['category'] = $item->content->{Str::camel($categoryFieldName)};
            }
            if ($item->content->comments) {
                $mergedAttributes['comments'] = $item->content->comments;
            }

            return $mergedAttributes;
        });

        return response()->json(
            $result
        );
    }
}
