<?php

namespace Inside\Statistics\Http\Controllers\Statistics;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Content\Facades\ContentHelper;
use Inside\Statistics\Contracts\Statistic;
use InvalidArgumentException;

class ContentStats
{
    public function __invoke(string $type, Request $request, Statistic $statistic): JsonResponse
    {
        if (! array_key_exists($type, config('statistics.types', []))) {
            throw new InvalidArgumentException();
        }

        return response()->json(
            $statistic->getContentStatistics($type, ContentHelper::extractFiltersInputFromRequest($request))
        );
    }
}
