<?php

namespace Inside\Statistics\Http\Controllers\Statistics;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Authentication\Models\User;
use Inside\Content\Facades\ContentHelper;
use Inside\Statistics\Repositories\StatisticsBetaRepository;

class AuthenticationStatsBeta
{
    public function __invoke(Request $request, StatisticsBetaRepository $statisticsRepository): JsonResponse
    {
        $filters = ContentHelper::extractFiltersInputFromRequest($request);
        $query = $statisticsRepository->getAuthenticationStatsQuery($filters);
        $result = ContentHelper::getResultFromQuery($query, $filters, true);

        $users = User::query()
            ->select(['uuid', 'last_login_at', 'last_access_at'])
            ->with(['information', 'roles'])
            ->whereIn('uuid', $result->pluck('user_uuid'))
            ->orderByField('uuid', $result->pluck('user_uuid')->toArray())
            ->get()
            ->map(function ($user) {
                $user->information->image = protected_file_url(
                    content : $user->information,
                    fieldName : 'image',
                    relative: true,
                    style: 'avatar',
                    webp: true
                );

                $user->information->full_name = $user->full_name;

                return $user;
            });

        return response()->json(
            $result->setCollection($users)
        );
    }
}
