<?php

namespace Inside\Statistics\Http\Controllers\Statistics;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Content\Facades\ContentHelper;
use Inside\Statistics\Contracts\Statistic;

class AuthenticationStats
{
    public function __invoke(Request $request, Statistic $statistic): JsonResponse
    {
        return response()->json(
            $statistic->getAuthenticationStats(ContentHelper::extractFiltersInputFromRequest($request))
        );
    }
}
