<?php

namespace Inside\Statistics\Http\Controllers\Exports;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Inside\Authentication\Models\User;
use Inside\Content\Facades\ContentHelper;
use Inside\Statistics\Exports\UserViewedContentStatsExport;
use Inside\Statistics\Listeners\NotifyUserOfCompletedStatisticExport;

class ExportUserViewedStats
{
    public function __invoke(
        string $type,
        string $uuid,
        string $format,
        Request $request
    ): JsonResponse {
        if (! in_array($format, config('statistics.allowed_export_formats', []))) {
            $format = 'csv';
        }

        $user = User::findOrFail($uuid);
        $query = $request->get('query');
        $excelPath = 'statistics/'.now()->format('YmdHis').'_'.Str::slug(
            $user->information->firstname.' '.$user->information->lastname
        ).'_'.$type.'_'.Str::random(8).'_export.'.$format;

        (new UserViewedContentStatsExport(
            $user->information,
            $type,
            ContentHelper::extractFiltersInputFromRequest($request),
            $query
        ))
            ->queue($excelPath, 'protected')
            ->chain([
                new NotifyUserOfCompletedStatisticExport(request()->user(), $excelPath, 'protected'),
            ])
            ->allOnQueue(get_low_priority_queue_name());

        return response()->json(
            [
                'success' => true,
            ]
        );
    }
}
