<?php

namespace Inside\Statistics\Http\Controllers\Exports;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Inside\Content\Facades\ContentHelper;
use Inside\Statistics\Exports\ContentStatsExport;
use Inside\Statistics\Listeners\NotifyUserOfCompletedStatisticExport;
use InvalidArgumentException;

class ExportContentStats
{
    public function __invoke(string $type, string $format, Request $request): JsonResponse
    {
        if (! array_key_exists($type, config('statistics.types', []))) {
            throw new InvalidArgumentException();
        }

        if (! in_array($format, config('statistics.allowed_export_formats', []))) {
            $format = 'csv';
        }

        $excelPath = 'statistics/content_'.$type.'_'.now()->format('YmdHis').'_'.Str::random(8).'_export.'.$format;
        (new ContentStatsExport($type, ContentHelper::extractFiltersInputFromRequest($request)))
            ->queue($excelPath, 'protected')
            ->chain([
                new NotifyUserOfCompletedStatisticExport($request->user(), $excelPath, 'protected'),
            ])
            ->allOnQueue(get_low_priority_queue_name());

        return response()->json(
            [
                'success' => true,
            ]
        );
    }
}
