<?php

namespace Inside\Statistics\Http\Controllers\Exports;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Inside\Authentication\Models\User;
use Inside\Content\Facades\ContentHelper;
use Inside\Statistics\Exports\ContentReadersStatsExport;
use Inside\Statistics\Listeners\NotifyUserOfCompletedStatisticExport;

class ExportContentReaderStats
{
    /**
     * @throws \Exception
     */
    public function __invoke(string $type, string $uuid, string $format, Request $request): JsonResponse
    {
        if (! in_array($format, config('statistics.allowed_export_formats', []))) {
            $format = 'csv';
        }

        $content = call_user_func(type_to_class($type).'::findOrFail', $uuid);
        $query = $request->get('query');
        $excelPath = 'statistics/'.now()->format('YmdHis').'_'.Str::slug($content->title).'_'.Str::random(8).'_export.'.$format;

        if (! request() instanceof Request) {
            throw new \Exception('Error User unknown');
        }

        $user = request()->user();

        (new ContentReadersStatsExport(
            $content,
            ContentHelper::extractFiltersInputFromRequest($request),
            $query
        ))
            ->queue($excelPath, 'protected')
            ->chain([
                new NotifyUserOfCompletedStatisticExport($user, $excelPath, 'protected'),
            ])
            ->allOnQueue(get_low_priority_queue_name());

        return response()->json(
            [
                'success' => true,
            ]
        );
    }
}
